/*
 * Decompiled with CFR 0.152.
 */
package com.altnoir.poopsky.block;

import com.altnoir.poopsky.worldgen.PSConfigureFeatures;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_174;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_7924;

public class PoopBlock
extends class_2248
implements class_2256 {
    protected static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);

    public PoopBlock(class_4970.class_2251 settings) {
        super(settings.method_50012(class_3619.field_15974).method_9628(0.8f));
    }

    private static boolean poopBlockEffects(class_1297 entity) {
        return entity instanceof class_1309 || entity instanceof class_1688 || entity instanceof class_1541 || entity instanceof class_1690;
    }

    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        entity.method_5783(class_3417.field_21074, 1.0f, 1.0f);
        if (entity.method_21750()) {
            super.method_9554(world, state, pos, entity, fallDistance);
        } else {
            entity.method_5747(fallDistance, 0.0f, world.method_48963().method_48827());
        }
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (this.isSliding(pos, entity)) {
            this.triggerAdvancement(entity, pos);
            this.updateSlidingVelocity(entity);
            this.addCollisionEffects(world, entity);
        }
        super.method_9548(state, world, pos, entity);
    }

    private boolean isSliding(class_2338 pos, class_1297 entity) {
        if (entity.method_24828()) {
            return false;
        }
        if (entity.method_23318() > (double)pos.method_10264() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (entity.method_18798().field_1351 >= -0.08) {
            return false;
        }
        double d = Math.abs((double)pos.method_10263() + 0.5 - entity.method_23317());
        double e = Math.abs((double)pos.method_10260() + 0.5 - entity.method_23321());
        double f = 0.4375 + (double)(entity.method_17681() / 2.0f);
        return d + 1.0E-7 > f || e + 1.0E-7 > f;
    }

    private void triggerAdvancement(class_1297 entity, class_2338 pos) {
        if (entity instanceof class_3222 && entity.method_37908().method_8510() % 20L == 0L) {
            class_174.field_21628.method_23909((class_3222)entity, entity.method_37908().method_8320(pos));
        }
    }

    private void updateSlidingVelocity(class_1297 entity) {
        class_243 vec3d = entity.method_18798();
        if (vec3d.field_1351 < -0.13) {
            double d = -0.04 / vec3d.field_1351;
            entity.method_18799(new class_243(vec3d.field_1352 * d, -0.04, vec3d.field_1350 * d));
        } else {
            entity.method_18799(new class_243(vec3d.field_1352, -0.04, vec3d.field_1350));
        }
        entity.method_38785();
    }

    private void addCollisionEffects(class_1937 world, class_1297 entity) {
        if (PoopBlock.poopBlockEffects(entity) && world.field_9229.method_43048(5) == 0) {
            entity.method_5783(class_3417.field_21074, 1.0f, 1.0f);
        }
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        double d = Math.abs(entity.method_18798().field_1351);
        if (d < 0.1 && !entity.method_21749()) {
            double e = 0.4 + d * 0.2;
            entity.method_18799(entity.method_18798().method_18805(e, 1.0, e));
        }
        super.method_9591(world, pos, state, entity);
    }

    protected class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1077();
    }

    protected class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1077();
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return world.method_8320(pos.method_10084()).method_26215();
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        world.method_30349().method_33310(class_7924.field_41239).flatMap(key -> key.method_40264(PSConfigureFeatures.POOP_PATCH_BONEMEAL)).ifPresent(entry -> ((class_2975)entry.comp_349()).method_12862((class_5281)world, world.method_14178().method_12129(), random, pos.method_10084()));
    }

    public class_2256.class_9077 method_55770() {
        return class_2256.class_9077.field_47834;
    }
}

